(function(blocks, i18n, element) {

	// Set up variables
	var el = element.createElement,
		__ = i18n.__;

	// Register Block - Title
	blocks.registerBlockType(
		'trx-addons/title',
		trx_addons_apply_filters( 'trx_addons_gb_map', {
			title: __( 'Title', "trx_addons" ),
			description: __( "Add title, subtitle and description", "trx_addons" ),
			keywords: [ 'title', 'heading' ],
			icon: 'editor-italic',
			category: 'trx-addons-blocks',
			attributes: trx_addons_apply_filters( 'trx_addons_gb_map_get_params', trx_addons_object_merge(
				trx_addons_gutenberg_get_param_title(),
				trx_addons_gutenberg_get_param_button(),
				trx_addons_gutenberg_get_param_id()
			), 'trx-addons/title' ),
			edit: function(props) {
				return trx_addons_gutenberg_block_params(
					{
						'render': true,
						'additional_params': el( wp.element.Fragment, { key: props.name + '-additional-params' },
							// Title params
							trx_addons_gutenberg_add_param_title( props, true  ),
							// ID, Class, CSS params
							trx_addons_gutenberg_add_param_id( props )
						)
					}, props
				);
			},
			save: function(props) {
				return el( '', null );
			}
		},
		'trx-addons/title'
	) );
})( window.wp.blocks, window.wp.i18n, window.wp.element );